/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.processing.basin;

import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinInventory;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class BasinRenderer
extends SmartBlockEntityRenderer<BasinBlockEntity, BasinRenderState> {
    public BasinRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public BasinRenderState createRenderState() {
        return new BasinRenderState();
    }

    @Override
    public void extractRenderState(BasinBlockEntity be, BasinRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        float fluidLevel = this.updateFluids(be, state, tickProgress);
        this.updateIngredients(be, state, tickProgress, fluidLevel);
        this.updateOutputs(be, state, tickProgress);
    }

    @Override
    public void submit(BasinRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.submit(state, matrices, queue, cameraState);
        if (state.fluids != null) {
            queue.method_73483(matrices, state.layer, (class_11659.class_11660)state);
        }
        if (state.ingredients != null) {
            matrices.method_22903();
            matrices.method_22904(0.5, (double)0.2f, 0.5);
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(state.ingredientYRot));
            for (IngredientRenderData ingredient : state.ingredients) {
                matrices.method_22903();
                matrices.method_61958(ingredient.itemPosition);
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(ingredient.yRot));
                matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(state.ingredientXRot));
                for (class_243 offset : ingredient.offsets) {
                    matrices.method_22903();
                    matrices.method_61958(offset);
                    ingredient.renderState.method_65604(matrices, queue, state.field_62676, class_4608.field_21444, 0);
                    matrices.method_22909();
                }
                matrices.method_22909();
            }
            matrices.method_22909();
        }
        if (state.outputs != null) {
            for (OutputItemRenderData item : state.outputs) {
                matrices.method_22903();
                matrices.method_61958(item.offset);
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(state.outputYRot));
                matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(item.xRot));
                item.renderState.method_65604(matrices, queue, state.field_62676, class_4608.field_21444, 0);
                matrices.method_22909();
            }
        }
    }

    public float updateFluids(BasinBlockEntity basin, BasinRenderState state, float partialTicks) {
        float totalUnits = basin.getTotalFluidUnits(partialTicks);
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        float xMin = 0.125f;
        float xMax = 0.125f;
        ArrayList<FluidRenderData> fluids = new ArrayList<FluidRenderData>();
        for (SmartFluidTankBehaviour behaviour : List.of(basin.getBehaviour(SmartFluidTankBehaviour.INPUT), basin.getBehaviour(SmartFluidTankBehaviour.OUTPUT))) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                float units;
                FluidStack renderedFluid = tankSegment.getRenderedFluid();
                if (renderedFluid.isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
                float partial = class_3532.method_15363((float)(units / totalUnits), (float)0.0f, (float)1.0f);
                fluids.add(new FluidRenderData(renderedFluid.getFluid(), renderedFluid.getComponentChanges(), xMin, xMax += partial * 12.0f / 16.0f));
                xMin = xMax;
            }
        }
        if (fluids.isEmpty()) {
            return 0.0f;
        }
        float fluidLevel = class_3532.method_15363((float)(totalUnits / 162000.0f), (float)0.0f, (float)1.0f);
        fluidLevel = 1.0f - (1.0f - fluidLevel) * (1.0f - fluidLevel);
        state.layer = class_12249.method_75977();
        state.fluids = fluids;
        state.yMin = 0.125f;
        state.yMax = state.yMin + 0.75f * fluidLevel;
        state.zMin = 0.125f;
        state.zMax = 0.875f;
        return state.yMax;
    }

    public void updateIngredients(BasinBlockEntity be, BasinRenderState state, float partialTicks, float fluidLevel) {
        BasinInventory inv = be.itemCapability;
        if (inv == null) {
            return;
        }
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        int size = inv.method_5439();
        for (int slot = 0; slot < size; ++slot) {
            class_1799 stack = inv.method_5438(slot);
            if (stack.method_7960()) continue;
            stacks.add(stack);
        }
        int itemCount = stacks.size();
        if (itemCount == 0) {
            return;
        }
        float level = class_3532.method_15363((float)(fluidLevel - 0.3f), (float)0.125f, (float)0.6f);
        class_5819 r = class_5819.method_43049((long)state.field_62673.hashCode());
        class_243 baseVector = new class_243(itemCount == 1 ? 0.0 : 0.125, (double)level, 0.0);
        class_1937 world = be.method_10997();
        float time = AnimationTickHolder.getRenderTime((class_1936)world);
        float anglePartition = 360.0f / (float)itemCount;
        IngredientRenderData[] ingredients = new IngredientRenderData[itemCount];
        int size2 = itemCount;
        for (int i = 0; i < size2; ++i) {
            class_1799 stack = (class_1799)stacks.get(i);
            class_243 itemPosition = VecHelper.rotate(baseVector, anglePartition * (float)itemCount, class_2350.class_2351.field_11052);
            if (fluidLevel > 0.0f) {
                itemPosition = itemPosition.method_1031(0.0, (double)((class_3532.method_15374((double)(time / 12.0f + anglePartition * (float)itemCount)) + 1.5f) * 1.0f / 32.0f), 0.0);
            }
            float yRot = (float)Math.PI / 180 * (anglePartition * (float)itemCount + 35.0f);
            class_10444 renderState = new class_10444();
            renderState.field_55337 = class_811.field_4318;
            this.itemModelManager.method_65596(renderState, stack, renderState.field_55337, world, null, 0);
            int count = stack.method_7947() / 8 + 1;
            class_243[] offsets = new class_243[count];
            for (int j = 0; j < count; ++j) {
                offsets[j] = VecHelper.offsetRandomly(class_243.field_1353, r, 0.0625f);
            }
            ingredients[i] = new IngredientRenderData(renderState, itemPosition, yRot, offsets);
            --itemCount;
        }
        state.ingredientYRot = (float)Math.PI / 180 * be.ingredientRotation.getValue(partialTicks);
        state.ingredientXRot = 1.134464f;
        state.ingredients = ingredients;
    }

    private void updateOutputs(BasinBlockEntity be, BasinRenderState state, float partialTicks) {
        if (!(state.field_62674.method_26204() instanceof BasinBlock)) {
            return;
        }
        class_2350 direction = (class_2350)state.field_62674.method_11654(BasinBlock.FACING);
        if (direction == class_2350.field_11033) {
            return;
        }
        List<IntAttached<class_1799>> visualizedOutputItems = be.visualizedOutputItems;
        if (visualizedOutputItems.isEmpty()) {
            return;
        }
        class_243 directionVec = class_243.method_24954((class_2382)direction.method_62675());
        class_243 outVec = VecHelper.getCenterOf((class_2382)class_2338.field_10980).method_1019(directionVec.method_1021(0.55).method_1023(0.0, 0.5, 0.0));
        class_1937 world = be.method_10997();
        boolean outToBasin = world.method_8320(state.field_62673.method_10093(direction)).method_26204() instanceof BasinBlock;
        ArrayList<OutputItemRenderData> outputs = new ArrayList<OutputItemRenderData>();
        for (IntAttached<class_1799> intAttached : visualizedOutputItems) {
            float progress = 1.0f - ((float)((Integer)intAttached.getFirst()).intValue() - partialTicks) / 10.0f;
            if (!outToBasin && progress > 0.35f) continue;
            class_243 offset = outVec.method_1031(0.0, (double)Math.max(-0.55f, -(progress * progress * 2.0f)), 0.0).method_1019(directionVec.method_1021((double)(progress * 0.5f)));
            float xRot = (float)Math.PI / 180 * progress * 180.0f;
            class_10444 renderState = new class_10444();
            renderState.field_55337 = class_811.field_4318;
            this.itemModelManager.method_65596(renderState, intAttached.getValue(), renderState.field_55337, world, null, 0);
            outputs.add(new OutputItemRenderData(renderState, offset, xRot));
        }
        if (outputs.isEmpty()) {
            return;
        }
        state.outputYRot = (float)Math.PI / 180 * AngleHelper.horizontalAngle(direction);
        state.outputs = outputs;
    }

    public int method_33893() {
        return 16;
    }

    @Environment(value=EnvType.CLIENT)
    public static class BasinRenderState
    extends SmartBlockEntityRenderer.SmartRenderState
    implements class_11659.class_11660 {
        public class_1921 layer;
        public float yMin;
        public float yMax;
        public float zMin;
        public float zMax;
        public List<FluidRenderData> fluids;
        public float ingredientYRot;
        public float ingredientXRot;
        public IngredientRenderData[] ingredients;
        public float outputYRot;
        public List<OutputItemRenderData> outputs;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (FluidRenderData data : this.fluids) {
                FluidRenderHelper.renderFluidBox(data.fluid, data.changes, data.xMin, this.yMin, this.zMin, data.xMax, this.yMax, this.zMax, vertexConsumer, matricesEntry, this.field_62676, false, false);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record IngredientRenderData(class_10444 renderState, class_243 itemPosition, float yRot, class_243[] offsets) {
    }

    @Environment(value=EnvType.CLIENT)
    public record OutputItemRenderData(class_10444 renderState, class_243 offset, float xRot) {
    }

    @Environment(value=EnvType.CLIENT)
    public record FluidRenderData(class_3611 fluid, class_9326 changes, float xMin, float xMax) {
    }
}

